#!/bin/bash

read -p "OK to completely remove NastPad? " -n 1 -r
if [[ ! $REPLY =~ ^[Yy]$ ]]
then
    [[ "$0" = "$BASH_SOURCE" ]] && exit 1 || return 1
fi

echo -e "\n--- removing mime types ---"
rm -fv {NP_SYS}/share/mime/packages/vnd.nastpad.model.xml
rm -fv {NP_SYS}/share/mime/packages/vnd.nastpad.result.xml
rm -fv {NP_SYS}/share/icons/gnome/scalable/mimetypes/text-vnd-nastpad-model.svg
rm -fv {NP_SYS}/share/icons/gnome/scalable/mimetypes/text-vnd-nastpad-result.svg
update-mime-database {NP_SYS}/share/mime

echo -e "\n--- removing application menu shortcut ---"
rm -fv {NP_SYS}/share/applications/nastpad.desktop
rm -fv {NP_SYS}/share/icons/hicolor/scalable/apps/nastpad.svg

echo -e "\n--- removing symlink ---"
rm -fv {NP_SYS}/bin/nastpad

echo -e "\n--- removing nastpad folder ---"
rm -frv {NP_DIR}

echo -e "\n--- FINISHED ---"
read -n1 -r -p "Press any key to continue..."

exit 0;

