#!/bin/bash

# modify install path variables below
if [[ $(id -u) = 0 ]]; then  # root user
   NP_SYS="/usr/local"
   NP_DIR="/opt/nastpad"
else  # 
   NP_SYS="$HOME/.local"
   NP_DIR="$HOME/nastpad"
fi


# script start
echo "--- NastPad installation script ---"
echo "Note: run as root user to install for all users"
echo "      (optional) modify install paths within the script file"
echo
read -p "OK to install NastPad to $NP_DIR? " -n 1 -r
echo
if [[ ! $REPLY =~ ^[Yy]$ ]]
then
    [[ "$0" = "$BASH_SOURCE" ]] && exit 1 || return 1
fi

cd $(dirname $0)

echo -e "\n--- creating NastPad directory structure ---"
mkdir -pv $NP_DIR
mkdir -pv $NP_DIR/libraries
mkdir -pv $NP_DIR/profiles
mkdir -pv $NP_DIR/parsers

echo -e "\n--- installing NastPad application files ---"
install -pv nastpad/NastPad $NP_DIR
install -pv nastpad/*.* $NP_DIR
install -pv nastpad/libraries/* $NP_DIR/libraries/
install -pv nastpad/profiles/* $NP_DIR/profiles/
install -pv nastpad/parsers/* $NP_DIR/parsers/

echo -e "\n--- installing symlink to bin ---"
mkdir -pv $NP_SYS/bin
ln -sfv $NP_DIR/NastPad $NP_SYS/bin/nastpad

echo -e "\n--- installing application menu shortcut ---"
# icon
mkdir -pv $NP_SYS/share/icons/hicolor/scalable/apps
cp -v extra/nastpad.svg $NP_SYS/share/icons/hicolor/scalable/apps
# .desktop file
sed -i "s|^Exec=.*|Exec=$NP_DIR/NastPad %F|" extra/nastpad.desktop
mkdir -pv $NP_SYS/share/applications
cp -v extra/nastpad.desktop $NP_SYS/share/applications

echo -e "\n--- installing file associations (mime types) ---"
# icons (assumes GNOME)
mkdir -pv $NP_SYS/share/icons/gnome/scalable/mimetypes
cp -v extra/text-vnd-nastpad-model.svg $NP_SYS/share/icons/gnome/scalable/mimetypes
cp -v extra/text-vnd-nastpad-result.svg $NP_SYS/share/icons/gnome/scalable/mimetypes
#gtk-update-icon-cache $NP_SYS/share/icons/gnome
# mime types
mkdir -pv $NP_SYS/share/mime/packages
cp -v extra/vnd.nastpad.model.xml $NP_SYS/share/mime/packages
cp -v extra/vnd.nastpad.result.xml $NP_SYS/share/mime/packages
update-mime-database $NP_SYS/share/mime

echo -e "\n--- creating uninstall script ---"
install -pv extra/uninstall.sh $NP_DIR
sed -i "s|{NP_SYS}|$NP_SYS|" $NP_DIR/uninstall.sh
sed -i "s|{NP_DIR}|$NP_DIR|" $NP_DIR/uninstall.sh

echo -e "\n --- FINISHED ---"
read -n1 -r -p "Press any key to continue..."

exit 0

